-- Definition von Beispieleigenschaften
INSERT INTO recnogroup ( reg_bez, reg_gruppe, reg_tablename, reg_pname, reg_bez_textno, reg_paramtype )
       SELECT 'Produktlebenszyklus',      'Nexar API', 'art', 'nexar.life_cycle.status',         35096, 'ptVARCHAR' WHERE NOT EXISTS( SELECT true FROM recnogroup WHERE reg_pname = 'nexar.life_cycle.status' ) UNION
       SELECT 'Toleranz',                 'Nexar API', 'art', 'nexar.tolerance',                  4408, 'ptNUMERIC' WHERE NOT EXISTS( SELECT true FROM recnogroup WHERE reg_pname = 'nexar.tolerance' ) UNION
       SELECT 'Betriebstemperatur (min)', 'Nexar API', 'art', 'nexar.min_operating_temperatur',  35097, 'ptNUMERIC' WHERE NOT EXISTS( SELECT true FROM recnogroup WHERE reg_pname = 'nexar.min_operating_temperatur' ) UNION
       SELECT 'Betriebstemperatur (max)', 'Nexar API', 'art', 'nexar.max_operating_temperatur',  35098, 'ptNUMERIC' WHERE NOT EXISTS( SELECT true FROM recnogroup WHERE reg_pname = 'nexar.max_operating_temperatur' ) ;
--

-- Definition des Mappings von dynamischen Feldern (siehe dynamische Einstellungen)
INSERT INTO x_10_interfaces.nexar_mapping (
              nexm_mapping_typ,
              nexm_table,
              nexm_column,
              nexm_cast,
              nexm_txt)
    --Artikelverwaltung
      -- Artikelbezeichnung
      SELECT 'Eingabefeld',
             'art',
             'ak_bez',
             'varchar(100)',
             '''<#$.manufacturer.name#> - <#$.shortDescription#>''' WHERE NOT EXISTS( SELECT true FROM x_10_interfaces.nexar_mapping WHERE nexm_mapping_typ = 'Eingabefeld' AND nexm_table = 'art'::regclass AND nexm_column = 'ak_bez' ) UNION
      -- HerstellerProduktNummer
      SELECT 'Eingabefeld',
             'art',
             'ak_herstelleraknr',
             'character varying',
             '''<#mpn#>''' WHERE NOT EXISTS( SELECT true FROM x_10_interfaces.nexar_mapping WHERE nexm_mapping_typ = 'Eingabefeld' AND nexm_table = 'art'::regclass AND nexm_column = 'ak_herstelleraknr' ) UNION
      -- Produktwebseite
      SELECT 'Eingabefeld',
             'art',
             'ak_herstelleraknr_url',
             'character varying',
             '''<#manufacturerUrl#>''' WHERE NOT EXISTS( SELECT true FROM x_10_interfaces.nexar_mapping WHERE nexm_mapping_typ = 'Eingabefeld' AND nexm_table = 'art'::regclass AND nexm_column = 'ak_herstelleraknr_url' ) UNION
      -- Zusatztext
      SELECT 'Eingabefeld',
             'art',
             'ak_txt',
             'character varying',
             E'''Zusätzliche Informationen\nDatenblatt: <#$.bestDatasheet.name#> - <#$.bestDatasheet.url#>''' WHERE NOT EXISTS( SELECT true FROM x_10_interfaces.nexar_mapping WHERE nexm_mapping_typ = 'Eingabefeld' AND nexm_table = 'art'::regclass AND nexm_column = 'ak_txt' ) UNION
    -- Lieferantenpreise
      -- Link zum Webshop
      SELECT 'Eingabefeld',
             'epreis',
             'e_url',
             'text',
             '''<#$.clickUrl#>''' WHERE NOT EXISTS( SELECT true FROM x_10_interfaces.nexar_mapping WHERE nexm_mapping_typ = 'Eingabefeld' AND nexm_table = 'epreis'::regclass AND nexm_column = 'e_url' ) UNION
      -- Updatezeitpunkt
      SELECT 'Eingabefeld',
             'epreis',
             'e_preis_last_updatetime',
             'timestamp without time zone',
             '''<#updated#>''' WHERE NOT EXISTS( SELECT true FROM x_10_interfaces.nexar_mapping WHERE nexm_mapping_typ = 'Eingabefeld' AND nexm_table = 'epreis'::regclass AND nexm_column = 'e_preis_last_updatetime' ) UNION
    -- Lieferantenanfrage
      -- Updatezeitpunkt
      SELECT 'Eingabefeld',
             'anfangebot',
             'aang_ep_last_updatetime',
             'timestamp without time zone',
             '''<#updated#>''' WHERE NOT EXISTS( SELECT true FROM x_10_interfaces.nexar_mapping WHERE nexm_mapping_typ = 'Eingabefeld' AND nexm_table = 'anfangebot'::regclass AND nexm_column = 'aang_ep_last_updatetime' )
  ;
-- Definition des Mappings von Parametern (siehe dynamische Einstellungen)
INSERT INTO x_10_interfaces.nexar_mapping (
          nexm_mapping_typ,
          nexm_table,
          nexm_cast,
          nexm_txt,
          nexm_reg_pname )
  -- Produktlebenszyklus
  SELECT 'Parameter',
         'art',
         'varchar(100)',
         '{"r_value":"''<#$.specs[*] ? (@.attribute.shortname == "lifecyclestatus") .value#>''","r_descr":"Produktlebenszyklus"}',
         'nexar.life_cycle.status' WHERE NOT EXISTS( SELECT true FROM x_10_interfaces.nexar_mapping WHERE nexm_mapping_typ = 'Parameter' AND nexm_table = 'art'::regclass AND nexm_reg_pname = 'nexar.life_cycle.status' ) UNION
  -- Toleranz
  SELECT 'Parameter',
         'art',
         'numeric',
         '{"r_value":"''<#$.specs[*] ? (@.attribute.shortname == "tolerance") .value#>''","r_descr":"Toleranz","r_unit":"%"}',
         'nexar.tolerance' WHERE NOT EXISTS( SELECT true FROM x_10_interfaces.nexar_mapping WHERE nexm_mapping_typ = 'Parameter' AND nexm_table = 'art'::regclass AND nexm_reg_pname = 'nexar.tolerance' ) UNION
    -- Betriebstemperatur (min)
  SELECT 'Parameter',
         'art',
         'numeric',
         '{"r_value":"''<#$.specs[*] ? (@.attribute.shortname == "minoperatingtemperature") .value#>''","r_descr":"Betriebstemperatur (min)","r_unit":"°C"}',
         'nexar.min_operating_temperatur' WHERE NOT EXISTS( SELECT true FROM x_10_interfaces.nexar_mapping WHERE nexm_mapping_typ = 'Parameter' AND nexm_table = 'art'::regclass AND nexm_reg_pname = 'nexar.min_operating_temperatur' ) UNION
    -- Betriebstemperatur (max)
  SELECT 'Parameter',
         'art',
         'numeric',
         '{"r_value":"''<#$.specs[*] ? (@.attribute.shortname == "maxoperatingtemperature") .value#>''","r_descr":"Betriebstemperatur (max)","r_unit":"°C"}',
         'nexar.max_operating_temperatur' WHERE NOT EXISTS( SELECT true FROM x_10_interfaces.nexar_mapping WHERE nexm_mapping_typ = 'Parameter' AND nexm_table = 'art'::regclass AND nexm_reg_pname = 'nexar.max_operating_temperatur' )
  ;
--

-- Definition der API Abfragen
INSERT INTO x_10_interfaces.nexar_api_call (
    nex_api,
    nex_ownerform )
  SELECT
      'query Search($mpn: String!) {' || E'\n' ||
      '    supSearchMpn(q: $mpn, country: "GER", currency: "EUR", limit: 1) {' || E'\n' ||
      '      results {' || E'\n' ||
      '        part {' || E'\n' ||
      '          mpn' || E'\n' ||
      '          id' || E'\n' ||
      '          shortDescription' || E'\n' ||
      '          similarParts {' || E'\n' ||
      '            mpn' || E'\n' ||
      '            id' || E'\n' ||
      '            shortDescription' || E'\n' ||
      '          }' || E'\n' ||
      '          bestImage {' || E'\n' ||
      '            url' || E'\n' ||
      '          }' || E'\n' ||
      '          bestDatasheet {' || E'\n' ||
      '            name' || E'\n' ||
      '            url' || E'\n' ||
      '            createdAt' || E'\n' ||
      '          }' || E'\n' ||
      '          manufacturerUrl' || E'\n' ||
      '          manufacturer {' || E'\n' ||
      '            name' || E'\n' ||
      '          }' || E'\n' ||
      '          specs {' || E'\n' ||
      '            attribute {' || E'\n' ||
      '              shortname' || E'\n' ||
      '            }' || E'\n' ||
      '            value' || E'\n' ||
      '            siValue' || E'\n' ||
      '          }' || E'\n' ||
      '          sellers {' || E'\n' ||
      '            company {' || E'\n' ||
      '              name' || E'\n' ||
      '              id' || E'\n' ||
      '              isVerified' || E'\n' ||
      '            }' || E'\n' ||
      '            offers {' || E'\n' ||
      '              id' || E'\n' ||
      '              inventoryLevel' || E'\n' ||
      '              factoryLeadDays' || E'\n' ||
      '              sku' || E'\n' ||
      '              moq' || E'\n' ||
      '              updated' || E'\n' ||
      '              prices {' || E'\n' ||
      '                quantity' || E'\n' ||
      '                convertedPrice' || E'\n' ||
      '                convertedCurrency' || E'\n' ||
      '              }' || E'\n' ||
      '            }' || E'\n' ||
      '          }' || E'\n' ||
      '        }' || E'\n' ||
      '      }' || E'\n' ||
      '    }' || E'\n' ||
      '  }',
      'TFormArtikel'
      WHERE NOT EXISTS( SELECT true FROM x_10_interfaces.nexar_api_call WHERE nex_ownerform = 'TFormArtikel');
INSERT INTO x_10_interfaces.nexar_api_call (
    nex_api,
    nex_ownerform )
  SELECT
      'query multipleMpns($queries: [SupPartMatchQuery!]!) {' || E'\n' ||
      '  supMultiMatch (country: "GER", currency: "EUR",' || E'\n' ||
      '    queries: $queries) {' || E'\n' ||
      '    hits' || E'\n' ||
      '    reference' || E'\n' ||
      '    parts {' || E'\n' ||
      '      id' || E'\n' ||
      '      name' || E'\n' ||
      '      mpn' || E'\n' ||
      '      shortDescription' || E'\n' ||
      '      manufacturerUrl' || E'\n' ||
      '      manufacturer {' || E'\n' ||
      '        name' || E'\n' ||
      '      }' || E'\n' ||
      '      specs {' || E'\n' ||
      '        attribute {' || E'\n' ||
      '          shortname' || E'\n' ||
      '        }' || E'\n' ||
      '        value' || E'\n' ||
      '      }' || E'\n' ||
      '      sellers {' || E'\n' ||
      '        company {' || E'\n' ||
      '          name' || E'\n' ||
      '          id' || E'\n' ||
      '          isVerified' || E'\n' ||
      '        }' || E'\n' ||
      '        offers {' || E'\n' ||
      '          id' || E'\n' ||
      '          inventoryLevel' || E'\n' ||
      '          factoryLeadDays' || E'\n' ||
      '          sku' || E'\n' ||
      '          moq' || E'\n' ||
      '          updated' || E'\n' ||
      '          prices {' || E'\n' ||
      '            quantity' || E'\n' ||
      '            convertedPrice' || E'\n' ||
      '            convertedCurrency' || E'\n' ||
      '          }' || E'\n' ||
      '        }' || E'\n' ||
      '      }' || E'\n' ||
      '      category {' || E'\n' ||
      '        id' || E'\n' ||
      '        name' || E'\n' ||
      '      }' || E'\n' ||
      '    }' || E'\n' ||
      '  }' || E'\n' ||
      '}',
      'TFormBestellVorschlag'
      WHERE NOT EXISTS( SELECT true FROM x_10_interfaces.nexar_api_call WHERE nex_ownerform = 'TFormBestellVorschlag');

